<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Carga Factura</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="icon" type="image/x-icon" href="favicon.png" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/perfect-scrollbar.min.css" />
    <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    <link defer rel="stylesheet" type="text/css" media="screen" href="assets/css/animate.css" />
    <script src="assets/js/perfect-scrollbar.min.js"></script>
    <script defer src="assets/js/popper.min.js"></script>
    <script defer src="assets/js/tippy-bundle.umd.min.js"></script>
    <script defer src="assets/js/sweetalert.min.js"></script>
</head>

<body x-data="main" class="relative overflow-x-hidden font-nunito text-sm font-normal antialiased" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.theme === 'dark' || $store.app.isDarkMode ?  'dark' : '', $store.app.menu, $store.app.layout,$store.app.rtlClass]">
    <!-- sidebar menu overlay -->
    <div x-cloak class="fixed inset-0 z-50 bg-[black]/60 lg:hidden" :class="{'hidden' : !$store.app.sidebar}" @click="$store.app.toggleSidebar()"></div>

    <!-- screen loader -->
    <div class="screen_loader animate__animated fixed inset-0 z-[60] grid place-content-center bg-[#fafafa] dark:bg-[#060818]">
        <img src="favicon.png" alt="">

    </div>

    <!-- scroll to top button -->
    <div class="fixed bottom-6 z-50 ltr:right-6 rtl:left-6" x-data="scrollToTop">
        <template x-if="showTopButton">
            <button type="button" class="btn btn-outline-primary animate-pulse rounded-full bg-[#fafafa] p-2 dark:bg-[#060818] dark:hover:bg-primary" @click="goToTop">
                <svg width="24" height="24" class="h-4 w-4" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M12 20.75C12.4142 20.75 12.75 20.4142 12.75 20L12.75 10.75L11.25 10.75L11.25 20C11.25 20.4142 11.5858 20.75 12 20.75Z" fill="currentColor" />
                    <path d="M6.00002 10.75C5.69667 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75L6.00002 10.75Z" fill="currentColor" />
                </svg>
            </button>
        </template>
    </div>

    <!-- start theme customizer section -->
    <?php include "template/header.php" ?>
    <!-- end theme customizer section -->

    <div class="main-container min-h-screen text-black dark:text-white-dark" :class="[$store.app.navbar]">
        <!-- start sidebar section -->
        <?php include "template/barra.php" ?>
        <!-- end sidebar section -->

        <div class="main-content flex min-h-screen flex-col">
            <!-- start header section -->
            <?php include "template/barra_sup.php" ?>
            <!-- end header section -->

            <?php
            include "api/adminEmpresas.php";
            include "api/adminConceptos.php";
            include "api/adminClientes.php";
            include "api/adminFormasPago.php";
            include "api/adminPagos.php";

            $adminEmpresas = new AdminEmpresas();
            $adminConceptos = new AdministradorConceptos();
            $adminClientes = new AdministradorClientes();
            $adminFormasPago = new AdministradorFormasPago();
            $adminPagos = new AdministradorPagos();
            $clientes = $adminClientes->dameClientes();
            $formasPago = $adminFormasPago->dameFormasPago();
            $metodosPago = $adminFormasPago->dameMetodosPago();
            $usosCfdi = $adminFormasPago->dameUsosCfdi();
            $empresas = $adminEmpresas->dameEmpresasLite();

            ?>
            <div class="animate__animated p-6" :class="[$store.app.animation]">
                <!-- start main content section -->
                <div x-data="sales">
                    <ul class="flex space-x-2 rtl:space-x-reverse">
                        <li>
                            <a href="javascript:;" class="text-primary hover:underline">Facturación </a>
                        </li>
                        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                            <span>Carga de facturas </span>
                        </li>
                    </ul>

                    <div class="pt-5">





                        <div class="panel">
                            <div class="mb-5 flex items-center justify-between">
                                <h5 class="text-lg font-semibold dark:text-white-light">Seleccione los XML</h5>
                            </div>
                            <div class="mb-5">
                                <form>
                                    <input type="file" name="archivos[]" id="archivos" placeholder="Some Text..." class="form-input" required="" multiple>
                                </form>
                            </div>

                        </div>


                        <br>

                        <div class="panel">
                            <div class="mb-5 flex items-center justify-between">
                                <h5 class="text-lg font-semibold dark:text-white-light">Facturación <?php echo $empresa->razon ?></h5>

                            </div>
                            <div class="mb-5">
                                <form class="space-y-5" @submit.prevent="submitForm5()">
                                    <div class="grid grid-cols-1 gap-5 md:grid-cols-1">

                                        <div>
                                            <label for="browserLname">Empresa</label>
                                            <select name="empresa" id="empresa" class="form-select">
                                                <option value="0">Seleccione empresa</option>
                                                <?php

                                                foreach ($empresas as $empresa) {
                                                    echo '<option value="' . $empresa->id . '">' . $empresa->razon . '</option>';
                                                }


                                                ?>
                                            </select>
                                        </div>

                                    </div>
                                    <div class="grid grid-cols-1 gap-5 md:grid-cols-2">
                                        <div>
                                            <label for="browserFname">Selecciona cliente</label>
                                            <select onchange="cargarClaves(this.value)" id="cliente" name="cliente" class="form-input">
                                                <?php
                                                foreach ($clientes as $cliente) {
                                                    if ($cliente->id == $movimiento->idCliente) {
                                                        echo "<option value='$cliente->id' selected>$cliente->nombre</option>";
                                                    } else {
                                                        echo "<option value='$cliente->id'>$cliente->nombre</option>";
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div>
                                            <label for="browserLname">Razón social</label>
                                            <select name="clave_c" id="clave_c" class="form-select">

                                            </select>
                                        </div>

                                    </div>
                                    <div class="grid grid-cols-1 gap-5 md:grid-cols-4">
                                        <div>
                                            <label for="browserCity">Método de pago </label>
                                            <select name="metodo_pago" id="metodo_pago" class="form-select">
                                                <?php
                                                foreach ($metodosPago as $metodoPago) {
                                                    if (isset($_GET['movimiento'])) {
                                                        if ($metodoPago->id == 1) {
                                                            echo "<option value='$metodoPago->id' selected>$metodoPago->metodo_pago</option>";
                                                        }
                                                    } else {
                                                        echo "<option value='$metodoPago->id'>$metodoPago->metodo_pago</option>";
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div>
                                            <label for="browserState">Forma de pago </label>
                                            <select name="forma_pago" id="forma_pago" class="form-select">
                                                <option value="0">Seleccione</option>
                                                <?php
                                                foreach ($formasPago as $formaPago) {
                                                    if (isset($_GET['movimiento'])) {
                                                        if ($formaPago->id == 3) {
                                                            echo "<option value='$formaPago->id' selected>$formaPago->forma_pago</option>";
                                                        } else {
                                                            echo "<option value='$formaPago->id'>$formaPago->forma_pago</option>";
                                                        }
                                                    } else {
                                                        echo "<option value='$formaPago->id'>$formaPago->forma_pago</option>";
                                                    }
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div>
                                            <label for="browserZip">Tipo de comprobante </label>
                                            <select name="tipo_comprobante" id="tipo_comprobante" required="" class="form-select">
                                                <option selected="" value=""></option>
                                                <option value="I" selected>Ingreso</option>
                                                <option value="E">Egreso</option>
                                                <option value="T">Traslado</option>
                                                <option value="N">Nomina</option>
                                                <option value="P">Pago</option>
                                            </select>
                                        </div>
                                        <div>
                                            <label for="browserCity">Uso De CFDI</label>
                                            <select name="uso_cfdi" id="uso_cfdi" class="form-select">
                                                <option value="0">Seleccione</option>
                                                <?php
                                                foreach ($usosCfdi as $usoCfdi) {

                                                    if (isset($_GET['movimiento'])) {
                                                        if ($usoCfdi->id == 3) {
                                                            echo "<option value='$usoCfdi->id' selected>$usoCfdi->uso_cfdi</option>";
                                                        } else {
                                                            echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                        }
                                                    } else {
                                                        echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                    }
                                                    //echo "<option value='$usoCfdi->id'>$usoCfdi->uso_cfdi</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="grid grid-cols-1 gap-5 md:grid-cols-4">

                                        <div>
                                            <label for="browserState">Estatus de pago</label>
                                            <select name="status_pago" id="status_pago" required="" class="form-select" <?php echo $seCargo ?>>

                                                <?php

                                                if (isset($_GET['movimiento'])) {
                                                    echo '
                                                   <option value="Pagado" selected>Pagado</option>';
                                                } else {
                                                    echo ' <option value="No Pagado">No Pagado</option>
                                                    <option value="Pagado" selected>Pagado</option>';
                                                }


                                                ?>

                                            </select>
                                        </div>
                                        <div>
                                            <label for="browserZip">Retención 4%</label>
                                            <select name="retencion_transporte" id="retencion_transporte" required="" class="form-select">
                                                <option value="No">No</option>
                                                <option value="Si">Si</option>
                                            </select>
                                        </div>


                                        <div>
                                            <label for="browserZip">Moneda</label>
                                            <select name="moneda" id="moneda" required="" class="form-select">
                                                <option value="1" selected>MXN</option>
                                                <option value="2">USD</option>
                                                <option value="3">EUR</option>

                                            </select>
                                        </div>
                                        <div>
                                            <label for="browserZip">Folio fiscal</label>
                                            <input type="text" name="folio_fiscal" id="folio_fiscal" class="form-input">
                                        </div>




                                    </div>


                                    <div class="grid grid-cols-1 gap-5 md:grid-cols-4">

                                        <div>
                                            <label for="browserState">Total sin iva</label>
                                            <input type="text" class="form-input" id="total_sin_iva" name="total_sin_iva">
                                        </div>
                                        <div>
                                            <label for="browserState">Total con iva</label>
                                            <input type="text" class="form-input" id="total_iva" name="total_iva">
                                        </div>
                                        <div>
                                            <label for="browserState">Fecha timbrado</label>
                                            <input type="date" class="form-input" id="fecha" name="fecha">
                                        </div>
                                        <div>
                                            <label for="browserState">Hora timbrado</label>
                                            <input type="time" class="form-input" id="hora" name="hora">
                                        </div>
                                    </div>

                                    <button type="submit" onclick="enviarFactura()" id="boton-terminar" class="btn btn-primary !mt-6">Terminar Factura</button>


                                </form>
                            </div>

                        </div>




                        <br>


                        <div class="panel">
                            <div class="mb-5 flex items-center justify-between">
                                <h5 class="text-lg font-semibold dark:text-white-light">Facturas cargadas</h5>

                            </div>
                            <div class="mb-5">
                                <div class="table-responsive">
                                    <table>
                                        <thead>
                                            <tr>
                                                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="0">Método de Pago</th>
                                                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="1">Forma de Pago</th>
                                                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="2">Empresa que factura</th>
                                                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="3">Total con IVA</th>
                                                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="5">Cliente</th>
                                                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Fecha de Timbrado</th>
                                                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Folio Fiscal</th>
                                                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">RFC RECEPTOR</th>
                                                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">RFC EMISOR</th>
                                                <th scope="col" data-tablesaw-sortable-col="" data-tablesaw-priority="persist">Acciones </th>

                                            </tr>
                                        </thead>
                                        <tbody id="tablaFacturas">


                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>





                    </div>
                </div>
            </div>
            <!-- end main content section -->

            <!-- start footer section -->
            <div class="mt-auto p-6 pt-0 text-center dark:text-white-dark ltr:sm:text-left rtl:sm:text-right">
                © <span id="footer-year">2024</span>. Sistema 14 Ultra All rights reserved.
            </div>
            <!-- end footer section -->
        </div>
    </div>

    <script src="assets/js/alpine-collaspe.min.js"></script>
    <script src="assets/js/alpine-persist.min.js"></script>
    <script defer src="assets/js/alpine-ui.min.js"></script>
    <script defer src="assets/js/alpine-focus.min.js"></script>
    <script defer src="assets/js/alpine.min.js"></script>
    <script src="assets/js/custom.js"></script>
    <script defer src="assets/js/apexcharts.js"></script>



    <script>
        var facturasArray = [];

        function cargarFactura(indice) {
            var espacioFolioFiscal = document.getElementById('folio_fiscal');
            var espacioMetodoPago = document.getElementById('metodo_pago');
            var espacioFormaPago = document.getElementById('forma_pago');
            var espacioTipoComprobante = document.getElementById('tipo_comprobante');
            var espacioCfdi = document.getElementById('uso_cfdi');
            var totalSinIva = document.getElementById('total_sin_iva');
            var totalConIva = document.getElementById('total_iva');
            var espacioFecha = document.getElementById('fecha');
            var espacioHora = document.getElementById('hora');
            var espacioEmpresa = document.getElementById('empresa');
            var espacioCliente = document.getElementById('cliente');
            var espacioClaveCorta = document.getElementById('clave_c');

            espacioFolioFiscal.value = data.folio_fiscal;
            espacioMetodoPago.value = data.metodo_pago;
            espacioFormaPago.value = data.forma_pago;
            espacioTipoComprobante.value = data.tipo_comprobante;
            espacioCfdi.value = data.usoCfdi;
            totalSinIva.value = data.sub_total;
            totalConIva.value = data.total;
            espacioFecha.value = data.fecha_timbrado;
            espacioHora.value = data.hora_timbrado;
            espacioEmpresa.value = data.empresa_id;
            espacioCliente.value = data.cliente_id;
            espacioClaveCorta.innerHTML = `<option value="${}">${data.nombre_clave}</option>`;

        }
    </script>


    <script>
        document.getElementById('archivos').addEventListener('change', function(event) {
            var tabla = document.getElementById('tablaFacturas');
            const files = event.target.files;
            if (files) {
                const apiUrl = 'api/scriptCargaFactura.php';
                const formData = new FormData();
                for (let i = 0; i < files.length; i++) {
                    formData.append('archivos[]', files[i]);
                    console.log("Se cargo el movimiento");

                }
                fetch(apiUrl, {
                        method: 'POST',
                        body: formData
                    })
                    .then(response => response.json())
                    .then(data => {
                        var medida = data.length;
                        for (var i = 0; i < medida; i++) {
                            facturasArray.push(data[i]);
                            tabla.innerHTML += `<tr>
                            <th>${data[i].metodo_pago}</th>
                            <th>${data[i].forma_pago}</th>
                            <th>${data[i].empresa_nombre}</th>
                            <th>${data[i].total}</th>
                            <th>${data[i].nombre_clave}</th>
                            <th>${data[i].fecha_timbrado}</th>
                            <th>${data[i].folio_fiscal}</th>
                            <th>${data[i].rfc_emisor}</th>
                            <th>${data[i].rfc_receptor}</th>
                            <th><button type="button" onclick="cargarFactura(${i})" class="btn btn-info">Editar</button></th>
                            </tr>`;

                        }

                    });
            }
        })
    </script>
    <script>
        document.addEventListener('alpine:init', () => {
            // main section
            Alpine.data('scrollToTop', () => ({
                showTopButton: false,
                init() {
                    window.onscroll = () => {
                        this.scrollFunction();
                    };
                },

                scrollFunction() {
                    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
                        this.showTopButton = true;
                    } else {
                        this.showTopButton = false;
                    }
                },

                goToTop() {
                    document.body.scrollTop = 0;
                    document.documentElement.scrollTop = 0;
                },
            }));

            // theme customization
            Alpine.data('customizer', () => ({
                showCustomizer: false,
            }));

            // sidebar section
            Alpine.data('sidebar', () => ({
                init() {
                    const selector = document.querySelector('.sidebar ul a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.click();
                                });
                            }
                        }
                    }
                },
            }));

            // header section
            Alpine.data('header', () => ({
                init() {
                    const selector = document.querySelector('ul.horizontal-menu a[href="' + window.location.pathname + '"]');
                    if (selector) {
                        selector.classList.add('active');
                        const ul = selector.closest('ul.sub-menu');
                        if (ul) {
                            let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                            if (ele) {
                                ele = ele[0];
                                setTimeout(() => {
                                    ele.classList.add('active');
                                });
                            }
                        }
                    }
                },

                notifications: [{
                        id: 1,
                        profile: 'user-profile.jpeg',
                        message: '<strong class="text-sm mr-1">John Doe</strong>invite you to <strong>Prototyping</strong>',
                        time: '45 min ago',
                    },
                    {
                        id: 2,
                        profile: 'profile-34.jpeg',
                        message: '<strong class="text-sm mr-1">Adam Nolan</strong>mentioned you to <strong>UX Basics</strong>',
                        time: '9h Ago',
                    },
                    {
                        id: 3,
                        profile: 'profile-16.jpeg',
                        message: '<strong class="text-sm mr-1">Anna Morgan</strong>Upload a file',
                        time: '9h Ago',
                    },
                ],

                messages: [{
                        id: 1,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-success-light dark:bg-success text-success dark:text-success-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path></svg></span>',
                        title: 'Congratulations!',
                        message: 'Your OS has been updated.',
                        time: '1hr',
                    },
                    {
                        id: 2,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-info-light dark:bg-info text-info dark:text-info-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="16" x2="12" y2="12"></line><line x1="12" y1="8" x2="12.01" y2="8"></line></svg></span>',
                        title: 'Did you know?',
                        message: 'You can switch between artboards.',
                        time: '2hr',
                    },
                    {
                        id: 3,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-danger-light dark:bg-danger text-danger dark:text-danger-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></span>',
                        title: 'Something went wrong!',
                        message: 'Send Reposrt',
                        time: '2days',
                    },
                    {
                        id: 4,
                        image: '<span class="grid place-content-center w-9 h-9 rounded-full bg-warning-light dark:bg-warning text-warning dark:text-warning-light"><svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">    <circle cx="12" cy="12" r="10"></circle>    <line x1="12" y1="8" x2="12" y2="12"></line>    <line x1="12" y1="16" x2="12.01" y2="16"></line></svg></span>',
                        title: 'Warning',
                        message: 'Your password strength is low.',
                        time: '5days',
                    },
                ],

                languages: [{
                        id: 1,
                        key: 'Chinese',
                        value: 'zh',
                    },
                    {
                        id: 2,
                        key: 'Danish',
                        value: 'da',
                    },
                    {
                        id: 3,
                        key: 'English',
                        value: 'en',
                    },
                    {
                        id: 4,
                        key: 'French',
                        value: 'fr',
                    },
                    {
                        id: 5,
                        key: 'German',
                        value: 'de',
                    },
                    {
                        id: 6,
                        key: 'Greek',
                        value: 'el',
                    },
                    {
                        id: 7,
                        key: 'Hungarian',
                        value: 'hu',
                    },
                    {
                        id: 8,
                        key: 'Italian',
                        value: 'it',
                    },
                    {
                        id: 9,
                        key: 'Japanese',
                        value: 'ja',
                    },
                    {
                        id: 10,
                        key: 'Polish',
                        value: 'pl',
                    },
                    {
                        id: 11,
                        key: 'Portuguese',
                        value: 'pt',
                    },
                    {
                        id: 12,
                        key: 'Russian',
                        value: 'ru',
                    },
                    {
                        id: 13,
                        key: 'Spanish',
                        value: 'es',
                    },
                    {
                        id: 14,
                        key: 'Swedish',
                        value: 'sv',
                    },
                    {
                        id: 15,
                        key: 'Turkish',
                        value: 'tr',
                    },
                    {
                        id: 16,
                        key: 'Arabic',
                        value: 'ae',
                    },
                ],

                removeNotification(value) {
                    this.notifications = this.notifications.filter((d) => d.id !== value);
                },

                removeMessage(value) {
                    this.messages = this.messages.filter((d) => d.id !== value);
                },
            }));

            // content section
            Alpine.data('sales', () => ({
                init() {
                    isDark = this.$store.app.theme === 'dark' || this.$store.app.isDarkMode ? true : false;
                    isRtl = this.$store.app.rtlClass === 'rtl' ? true : false;

                    const revenueChart = null;
                    const salesByCategory = null;
                    const dailySales = null;
                    const totalOrders = null;

                    // revenue
                    setTimeout(() => {
                        this.revenueChart = new ApexCharts(this.$refs.revenueChart, this.revenueChartOptions);
                        this.$refs.revenueChart.innerHTML = '';
                        this.revenueChart.render();

                        // sales by category
                        this.salesByCategory = new ApexCharts(this.$refs.salesByCategory, this.salesByCategoryOptions);
                        this.$refs.salesByCategory.innerHTML = '';
                        this.salesByCategory.render();

                        // daily sales
                        this.dailySales = new ApexCharts(this.$refs.dailySales, this.dailySalesOptions);
                        this.$refs.dailySales.innerHTML = '';
                        this.dailySales.render();

                        // total orders
                        this.totalOrders = new ApexCharts(this.$refs.totalOrders, this.totalOrdersOptions);
                        this.$refs.totalOrders.innerHTML = '';
                        this.totalOrders.render();
                    }, 300);

                    this.$watch('$store.app.theme', () => {
                        isDark = this.$store.app.theme === 'dark' || this.$store.app.isDarkMode ? true : false;

                        this.revenueChart.updateOptions(this.revenueChartOptions);
                        this.salesByCategory.updateOptions(this.salesByCategoryOptions);
                        this.dailySales.updateOptions(this.dailySalesOptions);
                        this.totalOrders.updateOptions(this.totalOrdersOptions);
                    });

                    this.$watch('$store.app.rtlClass', () => {
                        isRtl = this.$store.app.rtlClass === 'rtl' ? true : false;
                        this.revenueChart.updateOptions(this.revenueChartOptions);
                    });
                },

                // revenue
                get revenueChartOptions() {
                    return {
                        series: [{
                                name: 'Income',
                                data: [16800, 16800, 15500, 17800, 15500, 17000, 19000, 16000, 15000, 17000, 14000, 17000],
                            },
                            {
                                name: 'Expenses',
                                data: [16500, 17500, 16200, 17300, 16000, 19500, 16000, 17000, 16000, 19000, 18000, 19000],
                            },
                        ],
                        chart: {
                            height: 325,
                            type: 'area',
                            fontFamily: 'Nunito, sans-serif',
                            zoom: {
                                enabled: false,
                            },
                            toolbar: {
                                show: false,
                            },
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            curve: 'smooth',
                            width: 2,
                            lineCap: 'square',
                        },
                        dropShadow: {
                            enabled: true,
                            opacity: 0.2,
                            blur: 10,
                            left: -7,
                            top: 22,
                        },
                        colors: isDark ? ['#2196f3', '#e7515a'] : ['#1b55e2', '#e7515a'],
                        markers: {
                            discrete: [{
                                    seriesIndex: 0,
                                    dataPointIndex: 6,
                                    fillColor: '#1b55e2',
                                    strokeColor: 'transparent',
                                    size: 7,
                                },
                                {
                                    seriesIndex: 1,
                                    dataPointIndex: 5,
                                    fillColor: '#e7515a',
                                    strokeColor: 'transparent',
                                    size: 7,
                                },
                            ],
                        },
                        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
                        xaxis: {
                            axisBorder: {
                                show: false,
                            },
                            axisTicks: {
                                show: false,
                            },
                            crosshairs: {
                                show: true,
                            },
                            labels: {
                                offsetX: isRtl ? 2 : 0,
                                offsetY: 5,
                                style: {
                                    fontSize: '12px',
                                    cssClass: 'apexcharts-xaxis-title',
                                },
                            },
                        },
                        yaxis: {
                            tickAmount: 7,
                            labels: {
                                formatter: (value) => {
                                    return value / 1000 + 'K';
                                },
                                offsetX: isRtl ? -30 : -10,
                                offsetY: 0,
                                style: {
                                    fontSize: '12px',
                                    cssClass: 'apexcharts-yaxis-title',
                                },
                            },
                            opposite: isRtl ? true : false,
                        },
                        grid: {
                            borderColor: isDark ? '#191e3a' : '#e0e6ed',
                            strokeDashArray: 5,
                            xaxis: {
                                lines: {
                                    show: true,
                                },
                            },
                            yaxis: {
                                lines: {
                                    show: false,
                                },
                            },
                            padding: {
                                top: 0,
                                right: 0,
                                bottom: 0,
                                left: 0,
                            },
                        },
                        legend: {
                            position: 'top',
                            horizontalAlign: 'right',
                            fontSize: '16px',
                            markers: {
                                width: 10,
                                height: 10,
                                offsetX: -2,
                            },
                            itemMargin: {
                                horizontal: 10,
                                vertical: 5,
                            },
                        },
                        tooltip: {
                            marker: {
                                show: true,
                            },
                            x: {
                                show: false,
                            },
                        },
                        fill: {
                            type: 'gradient',
                            gradient: {
                                shadeIntensity: 1,
                                inverseColors: !1,
                                opacityFrom: isDark ? 0.19 : 0.28,
                                opacityTo: 0.05,
                                stops: isDark ? [100, 100] : [45, 100],
                            },
                        },
                    };
                },

                // sales by category
                get salesByCategoryOptions() {
                    return {
                        series: [985, 737, 270],
                        chart: {
                            type: 'donut',
                            height: 460,
                            fontFamily: 'Nunito, sans-serif',
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            width: 25,
                            colors: isDark ? '#0e1726' : '#fff',
                        },
                        colors: isDark ? ['#5c1ac3', '#e2a03f', '#e7515a', '#e2a03f'] : ['#e2a03f', '#5c1ac3', '#e7515a'],
                        legend: {
                            position: 'bottom',
                            horizontalAlign: 'center',
                            fontSize: '14px',
                            markers: {
                                width: 10,
                                height: 10,
                                offsetX: -2,
                            },
                            height: 50,
                            offsetY: 20,
                        },
                        plotOptions: {
                            pie: {
                                donut: {
                                    size: '65%',
                                    background: 'transparent',
                                    labels: {
                                        show: true,
                                        name: {
                                            show: true,
                                            fontSize: '29px',
                                            offsetY: -10,
                                        },
                                        value: {
                                            show: true,
                                            fontSize: '26px',
                                            color: isDark ? '#bfc9d4' : undefined,
                                            offsetY: 16,
                                            formatter: (val) => {
                                                return val;
                                            },
                                        },
                                        total: {
                                            show: true,
                                            label: 'Total',
                                            color: '#888ea8',
                                            fontSize: '29px',
                                            formatter: (w) => {
                                                return w.globals.seriesTotals.reduce(function(a, b) {
                                                    return a + b;
                                                }, 0);
                                            },
                                        },
                                    },
                                },
                            },
                        },
                        labels: ['Apparel', 'Sports', 'Others'],
                        states: {
                            hover: {
                                filter: {
                                    type: 'none',
                                    value: 0.15,
                                },
                            },
                            active: {
                                filter: {
                                    type: 'none',
                                    value: 0.15,
                                },
                            },
                        },
                    };
                },

                // daily sales
                get dailySalesOptions() {
                    return {
                        series: [{
                                name: 'Sales',
                                data: [44, 55, 41, 67, 22, 43, 21],
                            },
                            {
                                name: 'Last Week',
                                data: [13, 23, 20, 8, 13, 27, 33],
                            },
                        ],
                        chart: {
                            height: 160,
                            type: 'bar',
                            fontFamily: 'Nunito, sans-serif',
                            toolbar: {
                                show: false,
                            },
                            stacked: true,
                            stackType: '100%',
                        },
                        dataLabels: {
                            enabled: false,
                        },
                        stroke: {
                            show: true,
                            width: 1,
                        },
                        colors: ['#e2a03f', '#e0e6ed'],
                        responsive: [{
                            breakpoint: 480,
                            options: {
                                legend: {
                                    position: 'bottom',
                                    offsetX: -10,
                                    offsetY: 0,
                                },
                            },
                        }, ],
                        xaxis: {
                            labels: {
                                show: false,
                            },
                            categories: ['Sun', 'Mon', 'Tue', 'Wed', 'Thur', 'Fri', 'Sat'],
                        },
                        yaxis: {
                            show: false,
                        },
                        fill: {
                            opacity: 1,
                        },
                        plotOptions: {
                            bar: {
                                horizontal: false,
                                columnWidth: '25%',
                            },
                        },
                        legend: {
                            show: false,
                        },
                        grid: {
                            show: false,
                            xaxis: {
                                lines: {
                                    show: false,
                                },
                            },
                            padding: {
                                top: 10,
                                right: -20,
                                bottom: -20,
                                left: -20,
                            },
                        },
                    };
                },

                // total orders
                get totalOrdersOptions() {
                    return {
                        series: [{
                            name: 'Sales',
                            data: [28, 40, 36, 52, 38, 60, 38, 52, 36, 40],
                        }, ],
                        chart: {
                            height: 290,
                            type: 'area',
                            fontFamily: 'Nunito, sans-serif',
                            sparkline: {
                                enabled: true,
                            },
                        },
                        stroke: {
                            curve: 'smooth',
                            width: 2,
                        },
                        colors: isDark ? ['#00ab55'] : ['#00ab55'],
                        labels: ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10'],
                        yaxis: {
                            min: 0,
                            show: false,
                        },
                        grid: {
                            padding: {
                                top: 125,
                                right: 0,
                                bottom: 0,
                                left: 0,
                            },
                        },
                        fill: {
                            opacity: 1,
                            type: 'gradient',
                            gradient: {
                                type: 'vertical',
                                shadeIntensity: 1,
                                inverseColors: !1,
                                opacityFrom: 0.3,
                                opacityTo: 0.05,
                                stops: [100, 100],
                            },
                        },
                        tooltip: {
                            x: {
                                show: false,
                            },
                        },
                    };
                },
            }));
        });
    </script>
</body>

</html>